
rng(2002) ;

%%%%%%%%%%%%%%%
% simulations %
%%%%%%%%%%%%%%%

x_liftoff = zeros(Nsimul,6) ;
pi_liftoff = zeros(Nsimul,6) ;
t_liftoff = zeros(Nsimul,6) ;
mean_abs_x = zeros(Nsimul,6) ;
mean_abs_pi = zeros(Nsimul,6) ;
std_x = zeros(Nsimul,6) ;
std_pi = zeros(Nsimul,6) ;
std_di = zeros(Nsimul,6) ;
std_i = zeros(Nsimul,6) ;
is_reversal = zeros(Nsimul,6) ;
length_reversal = zeros(Nsimul,6) ;
neverleavesZLB = zeros(Nsimul,6) ;
maxpi = zeros(Nsimul,6) ;
minpi = zeros(Nsimul,6) ;
maxx = zeros(Nsimul,6) ;
minx = zeros(Nsimul,6) ;
indicRNR = zeros(Nsimul,6) ;
stdshockcheck = zeros(Nsimul,6) ;
meanshockcheck = zeros(Nsimul,6) ;
meanpathcheck = zeros(Nsimul,6) ;
stdpathcheck = zeros(Nsimul,6) ;

median_i_path = zeros(T,6) ;
median_x_path = zeros(T,6) ;
median_pi_path = zeros(T,6) ;
mean_i_path = zeros(T,6) ;
mean_x_path = zeros(T,6) ;
mean_pi_path = zeros(T,6) ;


i_pathSS = zeros(T,Nsimul) ;
x_pathSS = zeros(T,Nsimul) ;
pi_pathSS = zeros(T,Nsimul) ;
nat_pathSS = zeros(T,Nsimul) ;
nat_path_shockSS = zeros(T,Nsimul) ;
eps_path = zeros(T,Nsimul) ;
u_path = zeros(T,Nsimul) ;

for i=1:Nsimul
    eps_path(1:T+1,i) = simmarkovgiveinit(P_eps,T+1,feps) ;
    u_path(1:T+1,i) = simmarkovgiveinit(P_u,T+1,fu) ;
end


for us=1:6;
    if us==1; i_pathK = i_path3   ; x_pathK = x_path3   ; pi_pathK = pi_path3   ; end
    if us==2; i_pathK = i_pathR3  ; x_pathK = x_pathR3  ; pi_pathK = pi_pathR3  ; end
    if us==3; i_pathK = i_pathRB3 ; x_pathK = x_pathRB3 ; pi_pathK = pi_pathRB3 ; end
    if us==4; i_pathK = i_pathRC3 ; x_pathK = x_pathRC3 ; pi_pathK = pi_pathRC3 ; end
    if us==5; i_pathK = i_pathRD3   ; x_pathK = x_pathRD3   ; pi_pathK = pi_pathRD3   ; end
    if us==6; i_pathK = i_path1   ; x_pathK = x_path1   ; pi_pathK = pi_path1   ; end
    
    for i=1:Nsimul
        for t=1:T
            i_pathSS(t,i) = i_pathK(t,eps_path(t,i),u_path(t,i)) ;
            x_pathSS(t,i) = x_pathK(t,eps_path(t,i),u_path(t,i)) ;
            pi_pathSS(t,i) = pi_pathK(t,eps_path(t,i),u_path(t,i)) ;
            nat_path_shockSS(t,i) = scalefactor(t)*std_eps*grid_eps(eps_path(t,i)) ; % note this is not true for t>=T3
            nat_pathSS(t,i) = rhomean(t) + nat_path_shockSS(t,i) ;
        end
    end
    % annualize, transform back from dev of steady-state to real
    % numbers:
    pi_pathSS = 400*(pi_pathSS+pistar) ;
    x_pathSS = 100*x_pathSS ;
    i_pathSS = 400*(i_pathSS-ZLBI) ;
    
    nat_pathSS = 400*(nat_pathSS) ;
    % define liftoff and reversals
    
    for i=1:Nsimul
        if max(i_pathSS(:,i))<thresholdzlb; % never lifts off in the simulation.
            first_liftoff = T11 + 1 ;
            neverleavesZLB(i,us) =  1 ;
            is_reversal(i,us) = - 1 ;
            length_reversal(i,us) = - 1 ; % -1 if undefined
        else
            neverleavesZLB(i,us) =  0 ; % does liftoff
            first_liftoff = find(i_pathSS(:,i)>=thresholdzlb, 1, 'first' ) ;
            if min(i_pathSS(first_liftoff:T11))<thresholdzlb % at some point go back below threshold
                is_reversal(i,us) =  1 ; % 1 if exists one reversal
                length_reversal(i,us) = sum( (i_pathSS(first_liftoff:T11) <thresholdzlb) ) ;
            else
                is_reversal(i,us) =  0 ;
                length_reversal(i,us) = 0 ; % 0 if never reverses
            end
        end
        
        
        maxpi(i,us) = max(pi_pathSS(1:T11)) ;
        minpi(i,us) = min(pi_pathSS(1:T11)) ;
        maxx(i,us)  = max(x_pathSS(1:T11)) ;
        minx(i,us)  = min(x_pathSS(1:T11)) ;
        t_liftoff(i,us) = first_liftoff ;
        
        
        
        if first_liftoff<T11+1
            x_liftoff(i,us) =  x_pathSS(first_liftoff) ;
            pi_liftoff(i,us) =  pi_pathSS(first_liftoff) ;
        else
            x_liftoff(i,us) = NaN ;
            pi_liftoff(i,us) =  NaN ;
        end
        
        % indicator that real natural rate is negative the period after liftoff.
        if first_liftoff>=1&&first_liftoff<T11-1
            if us<5
                indicRNR(i,us) = ( grid_eps(eps_path(first_liftoff+1))*std_eps*scalefactor(first_liftoff+1) + rhomean(first_liftoff+1) <= 0 ) ;
            else
                indicRNR(i,us) = ( grid_eps(eps_path(first_liftoff+1))*1e-7*std_eps*scalefactor(first_liftoff+1) + rhomean(first_liftoff+1) <= 0 ) ;
            end
        else
            indicRNR(i,us) = NaN ;
        end
        % other stats: mean abs x, std(x) over simul
        mean_abs_x(i,us) = mean(abs(x_pathSS(:,i))) ;
        mean_abs_pi(i,us) = mean(abs(pi_pathSS(:,i))) ;
        std_x(i,us) = std(x_pathSS(:,i)) ;
        std_pi(i,us) = std(pi_pathSS(:,i)) ;
        std_di(i,us) = std(i_pathSS(2:end,i)-i_pathSS(1:end-1,i)) ;
        std_i(i,us) = std(i_pathSS(:,i)) ;
        
        stdshockcheck(i,us) = std(nat_path_shockSS(:,i)) ;
        meanshockcheck(i,us) = mean(nat_path_shockSS(:,i)) ;
        meanpathcheck(i,us) = mean(nat_pathSS(:,i)) ;
        stdpathcheck(i,us)  = std(nat_pathSS(:,i)) ;
    end
    
    for t=1:T
        median_i_path(t,us) = nanmedian(i_pathSS(t,:)) ;
        median_x_path(t,us) = nanmedian(x_pathSS(t,:)) ;
        median_pi_path(t,us) = nanmedian(pi_pathSS(t,:)) ;
        mean_i_path(t,us) = nanmean(i_pathSS(t,:)) ;
        mean_x_path(t,us) = nanmean(x_pathSS(t,:)) ;
        mean_pi_path(t,us) = nanmean(pi_pathSS(t,:)) ;
    end
    
    
end


% store loss function values
AX = 16*100*[ Loss3(1,feps,fu), LossR3(1,feps,fu) , LossRB3(1,feps,fu) , LossRC3(1,feps,fu),  LossRD3(1,feps,fu),Loss1(1,feps,fu)]  ;

% store statistics:
X1k = zeros(1,6) ;
X1kSD = zeros(1,6) ;
X2k = zeros(1,6) ;
X2kSD = zeros(1,6) ;
X3k = zeros(1,6) ;
X3kSD = zeros(1,6) ;
p95maxpi = zeros(1,6) ;
p90maxpi = zeros(1,6) ;
p75maxpi = zeros(1,6) ;
p25minx = zeros(1,6) ;
p10minx = zeros(1,6) ;
p5minx = zeros(1,6) ;

for us=1:6 ;
    TT = find(is_reversal(is_reversal(:,us)>-.5)) ;
    X1k(us) = mean(is_reversal(TT,us)) ;
    X1kSD(us) = std(is_reversal(TT,us)) ;
    
    TT = find(length_reversal(:,us)>=0.5) ;
    TT2 = find(length_reversal(:,us)>=-0.5) ;
    
    X2k(us) = mean(length_reversal(TT,us)) ;
    X2kSD(us) = std(length_reversal(TT,us)) ;
    X3k(us) = mean(length_reversal(TT2,us)) ;
    X3kSD(us) = std(length_reversal(TT2,us)) ;
    
    p95maxpi(us) = prctile(maxpi(:,us),95) ;
    p90maxpi(us) = prctile(maxpi(:,us),90) ;
    p75maxpi(us) = prctile(maxpi(:,us),75) ;
    
    p25minx(us) = prctile(minx(:,us),25) ;
    p10minx(us) = prctile(minx(:,us),10) ;
    p5minx(us) = prctile(minx(:,us),5) ;
end

fmt = ' %6.2f ' ;
TableShow = [AX;nanmean(t_liftoff);nanmedian(t_liftoff);nanmean(x_liftoff);nanmedian(x_liftoff);nanmean(pi_liftoff);nanmedian(pi_liftoff);p75maxpi;p25minx;nanmean(indicRNR);nanmean(std_di) ;nanmedian(std_di);nanmean(std_i) ;nanmedian(std_i) ] ;
row = {'Loss';'Mean time to liftoff';'Median time to liftoff'; 'Mean x at liftoff' ; 'Median x at liftoff' ; 'Mean pi at liftoff';'Median pi at liftoff'; 'p75 of max pi'; 'p25 of min x';'Prob of neg nat rate after liftoff';'mean STD Delta i';'median STD Delta i';'mean STD i';'median STD i'} ;
head2 = {'Opt. Discr','Nat Rate','Nat Rate + Infl','TR cst int','Naive Fed','No Unc'} ;
% texprint(TableShow,fmt, head2, row)

% simpler table --
axa= [1,5,4] ;
axa2 = [1,2,3,7,5,8,9,12];
texprint(TableShow(axa2,axa),fmt, head2(axa), row(axa2))
    